/*
 * Decompiled with CFR 0.152.
 */
package tiled.util;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Vector;
import tiled.core.Map;
import tiled.core.MapLayer;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.core.TileSet;

public class TileMergeHelper {
    private Map myMap;
    private TileSet myTs;
    private Vector<Cell> cells;

    public TileMergeHelper(Map map) {
        this.myMap = map;
        this.cells = new Vector();
        this.myTs = new TileSet();
        this.myTs.setName("Merged Set");
    }

    public TileLayer merge(int start, int len, boolean all) {
        Rectangle r = this.myMap.getBounds();
        TileLayer mergedLayer = new TileLayer(r);
        for (int i = 0; i < r.height; ++i) {
            for (int j = 0; j < r.width; ++j) {
                mergedLayer.setTileAt(j, i, this.createCell(j, i, start, len, all));
            }
        }
        return mergedLayer;
    }

    public TileSet getSet() {
        return this.myTs;
    }

    public Tile createCell(int tx, int ty, int start, int len, boolean all) {
        Cell c = new Cell(this.myMap, tx, ty, start, len, all);
        for (Cell check : this.cells) {
            if (!check.equals(c)) continue;
            return check.getTile();
        }
        this.cells.add(c);
        Tile tile = new Tile();
        c.setTile(tile);
        GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage tileImg = config.createCompatibleImage(c.getWidth(), c.getHeight());
        c.render(((Image)tileImg).getGraphics());
        tile.setImage(tileImg);
        this.myTs.addTile(tile);
        return tile;
    }

    private class Cell {
        private Vector<Tile> sandwich = new Vector();
        private Tile myTile;

        public Cell(Map map, int posx, int posy, int start, int len, boolean all) {
            for (int i = 0; i < len; ++i) {
                MapLayer ml = map.getLayer(start + i);
                if (!(ml instanceof TileLayer)) continue;
                TileLayer l = (TileLayer)ml;
                if (l.isVisible() || all) {
                    this.sandwich.add(l.getTileAt(posx, posy));
                    continue;
                }
                this.sandwich.add(null);
            }
        }

        public void setTile(Tile t) {
            this.myTile = t;
        }

        public Tile getTile() {
            return this.myTile;
        }

        public void render(Graphics g) {
            for (Tile tile : this.sandwich) {
                if (tile == null) continue;
                tile.draw(g, 0, this.getHeight(), 1.0);
            }
        }

        public boolean equals(Cell c) {
            Iterator<Tile> me = this.sandwich.iterator();
            Iterator<Tile> them = c.sandwich.iterator();
            while (me.hasNext()) {
                Tile m = me.next();
                Tile t = them.next();
                if (m != null && t != null && !m.equals(t)) {
                    return false;
                }
                if (m != null && t != null && t != m) {
                    return false;
                }
                if ((m == null || t != null) && (m != null || t == null)) continue;
                return false;
            }
            return true;
        }

        public int getWidth() {
            int width = 0;
            for (Tile tile : this.sandwich) {
                int w;
                if (tile == null || (w = tile.getWidth()) <= width) continue;
                width = w;
            }
            return width;
        }

        public int getHeight() {
            int height = 0;
            for (Tile tile : this.sandwich) {
                int h;
                if (tile == null || (h = tile.getHeight()) <= height) continue;
                height = h;
            }
            return height;
        }
    }
}

